


/******************************************************************************************
 *                                                                                        *
 *   Ex1.      :   Read ASCII Code From Touch PAD Key 4x4 Out Hex Code To LED Port0	      *
 *                 By Use Interupt Recive ASCII Code                                      *
 *                                  (Format:Press Single Key Only) 	                      *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 * Target MCU     : ATMEL AT89C51ED2                                                      *
 *       	      : X-TAL : 18.432 MHz                                                    *
 *                                                                                        *
 * Keil Editor    : uVision3 V3.62C                                                       *
 * Compiler       : Keil C51 (V9.51)                                                      *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                  *
 * Last Update    : 09/September/2014                                                     *
 *																				          *
 * Port Interface :  -- MCU-AT89C51RE2--	  	  	      -- Key Touch PAD 4x4 --         *  
 *                                                                                        *
 *																						  *
 *       Uart0    :  P3.0 = RXDO 		   Connect                Tx of Board Touch Key   *  
 *                   P3.1 = TXD0		   Connect                Rx of Board Touch Key	  *
 *                   Baud Rate = 9600  at Clock 18.432Mhz(6Clock Mode)                    *
 *                                                                                        *
 *    LED DISPLAY : P0[0..7]	           Connect	              LED Common Anode 		  *
 *                                                                						  *  
 *                                                                             5V		  *
 *                                                                             -+- 		  *
 *                                                              560      \\     |  		  *
 *                                                     P0.0 --/\/\/\---|<|-----+		  *
 *												 	             	 	 .	    |		  *
 *                                                              560      . \\   | 		  *
 *                                                     P0.7 --/\/\/\-----|<|---+  		  *
 *																						  *
 *                                                                                        *
 *   Operation    : When Touch Key will Show Key Code(Hex of Ascii) on LED PORT0[0..7]    *
 *																						  *
 *																					      *
 ******************************************************************************************/



#include <at89c51xd2.h>           /* AT89C51xD2 definitions                   */
#include <stdio.h>                /* prototype declarations for I/O functions */


char key[3] ,n=0                    ;


 //******** Interrupt Service Receive DATA UART0 **********
//********************************************************
  
void Rx_data() interrupt 4 
  {
	  if(RI == 1)	                          //If Flag RI =  1 is INT.form Rx
	  {
		 key[n]    = SBUF                  ;  //Step1: Read ASCII Code 3 Byte
		 RI = 0							   ;  //Clear Flag
		 n++                               ;  //Pointer Array	  

		 if(n == 3)			               	  //if Pointer= 3 Clear Pointer=0
			n=0                            ;
	
      }	 //if IR 
   }

   
//*************************** Main *************************

 main (void) 
  {
      
    CKCON0 = 0x01   ;  // div 6 clk mode  X2=1
    AUXR   = 0x10   ;  //Set XRAM = 1792 Byte
     
   //---------initial Uart0 ------------

    BRL     = 0x88  ;  // Baud Rate 9600
    PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR                        
 	BDRCON |= 0x1E  ;  // Select Internal Baud-Rate,enable,0x1E=Fast //0x1C=No fast 	 
    SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
    ES      = 0     ;  // Disable Serial Uart  Interrupt    
  
    TI=1            ;
  
    ES = 1          ;  //Enable Serial Uart Interrupt 
    EA = 1          ;  //Enable global Interrupt 
  
    while(1)
	 {
	   if(key[2] == 0x0D)             //Step2: Check data Last Byte readded              
	    {
	      key[2] =0 ;	             //Step3: Clear data in buffer array key[2]
			
		  if(key[0]=='P')		     //Step4: Check  Status  Pressed key (ASCII Code = 'P')
		   {
             //------ Step5 : Write Program Support Press Single Key of User ------ 
		                
		 	 P0 = ~key[1]                                   ; //Out data key Code to LED P0[0..7]
			   
			 while(key[0] != 'R') {;}    //wait Release Key (when key[0]=R) for Exit Loop   
			 P0 = 0xFF            ;      //Clear LED PORT P0             
		   }
	    }  //if key[2]    
	 } //while
  }

